### 概述

本事例演示了工智机连接 canopen 设备，工智机发送数据给 canopen 输出端 output， canopen 接受到数据并用万用表测量，万用表显示为 0.3V；canopen 输入端 input 接入电源时，metafacture 中对应的变量通道可显示为 true，那么可验证该工智机及 IDE 支持参 open 通讯。

下载：🧷**[MetaFacture与CANopen通讯](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/attachments/CANopen通讯.zip "CANopen通讯.zip")**

---

### 软硬件配置

硬件：SX20-01(工智机) GCAN-4056(Canopen IO) FLUKE(万用表)

软件：MetaFacture 1.0.4.0

硬件连接示意图

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/671626858bf53.png)

---

### 实验步骤

（一）新建工程

打开 MetaFacture 软件，新建一个标准工程，设备选择 sinsegye，编程语言可选择结构化文本（ST）。

（二）查看工智机 IP 地址

1\. 将工智机连接网线、电源、显示器、鼠标、键盘，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/67162685ea774)

中科时代的工智机内置了Ubuntu 系统或 Windows 系统。

Windows 系统，在开始菜单栏输入 CMD 打开终端命令窗口，输入'ipconfig'。

Ubuntu 系统，在终端中输入'ifconfig'。可在显示器上查看对应网口的 IP 地址。

（三）添加驱动器 xml 文件

点击【菜单栏】-【工具】-【设备存储库】。

在弹窗中，点击【安装】。

将 GCAN-4056-230811.eds 该文件添加至 MetaFacture 中，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/6716268665136)

完成后，设备栏的状态如下图所示。

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/67162686df0b4)

（四）添加设备

1.在 MetaFacture 1.0.4.0“设备树”中选择【device】并右键，点击【添加设备】。

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/6716268746363)

2.在弹出窗口中，选择【现场总线】-【canbus】-【canbus】，点击【添加设备】，如下图。

3.选中【canbus】，右键【添加设备】，【现场总线】-【canopen】-【canopen 管理器】-【canopen\_manager】，如下图所示。如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/67162687c69e4)

（五）工程基本配置

Canbus 基本配置

 双击“设备树”中【CANbus】，在【通用】中，将【网络】设置为【0】，【波特率】设置为【1000】(波特率应与canopen 盒子，Band 区域设置保持一致)，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/671626884cc3d)

CANopen\_Manager 参数配置

双击“设备树”中【CANbus】，在【通用】中，将【节点 ID】修改为【127】节点 ID： 默认一般为 127 无需更改，官方文档说明，节点号将 CANopen 管理器标识为唯一的

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/67162688cf2d0)（值范围：1...127），如下图。

CANopen 盒子配置-GCAN\_4056

双击“设备树”中【CANbus】，在【通用】中，将【节点 ID】修改为【1】，节点 ID： 与 canopen 盒子 Node ID 区域配置保持一致，此处默认为 1，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/671626894b71f.png)

（六）实验步骤

GCAN-4056 8 路数字输入(8DI)

V-和 V+接电源，给盒子自己供电

另一端 CAN\_H 和 CAN\_L 按照 CAN 线序与工智机 COM 口正确连接

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/67162689ba952)

DI\_GND 接负极，DI\_7 接正极，接入一路 24V 信号，在 MetaFacture 中点击【生成代码】

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/6716268a1ff8c)-【运行】-【登录】，可以看出%IX0.7 为 true，如下图，那么 canopenDI 端输入的信号已被 metafacture 成功接收到。

GCAN-4056 8 路输出 数字信号(8DO)

在 MetaFacture 中点击【生成代码】-【运行】-【登录】，并修改 OUTput 区域 %QX0.5、%QX0.6、%QX0.7 为 Ture。如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/QlTSmBbb/6716268aa3bd6)

使用万用表通断模式，负极接 DO\_GND，正极接到 DO\_5、DO\_6、DO\_7 均有蜂鸣声。

使用万用表直流电压模式测试输出模块电压，负极接 DO\_GND，正极接到 DO\_5、DO\_6、 DO\_7 为 true 的通道电压为 0；负极接 DO\_GND，正极接到 DO\_4 为 false 的通道电压为0.3V。

---

### 结论

如上述步骤可以得出，工智机发送数据给 canopen，canopen 接受到数据并用万用表测量时，万用表显示为 0V；canopen 输入端 input 接入电源时，metafacture 中对应的变量显示为true，那么可以得出该工智机支持 canopen 通讯。